/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network.rci.entry;

import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.network.rci.MirrorConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.MirrorEntryInfoBase;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;

public class MirrorEntryInfo<T>
extends MirrorEntryInfoBase<T> {
    private final T defaultValue;
    private final Type valueType;
    private final int width;
    private final double minValue;
    private final double maxValue;

    public MirrorEntryInfo(PacketSender packetSender, MirrorConfigCategory category, String entryName, T defaultValue, Type valueType, int width, double minValue, double maxValue) {
        super(packetSender, category, entryName);
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public static Object read(class_2540 buf, Type type) {
        if (!buf.readBoolean()) {
            return null;
        }
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TInt.class, Type.TLong.class, Type.TFloat.class, Type.TDouble.class, Type.TString.class, Type.TBool.class, Type.TEnum.class, Type.TUnknown.class}, (Object)type3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Type.TInt tInt = (Type.TInt)type3;
                yield buf.readInt();
            }
            case 1 -> {
                Type.TLong tLong = (Type.TLong)type3;
                yield buf.readLong();
            }
            case 2 -> {
                Type.TFloat tFloat = (Type.TFloat)type3;
                yield Float.valueOf(buf.readFloat());
            }
            case 3 -> {
                Type.TDouble tDouble = (Type.TDouble)type3;
                yield buf.readDouble();
            }
            case 4 -> {
                Type.TString tString = (Type.TString)type3;
                yield buf.method_19772();
            }
            case 5 -> {
                Type.TBool tBool = (Type.TBool)type3;
                yield buf.readBoolean();
            }
            case 6 -> {
                Type.TEnum tEnum = (Type.TEnum)type3;
                yield tEnum.optionForString(buf.method_19772());
            }
            case 7 -> {
                Type.TUnknown tUnknown = (Type.TUnknown)type3;
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void write(class_2540 buf, Type type, Object data) {
        if (data == null) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            Type type2 = type;
            Objects.requireNonNull(type2);
            Type type3 = type2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TInt.class, Type.TLong.class, Type.TFloat.class, Type.TDouble.class, Type.TString.class, Type.TBool.class, Type.TEnum.class, Type.TUnknown.class}, (Object)type3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Type.TInt tInt = (Type.TInt)type3;
                    buf.method_53002(((Integer)data).intValue());
                    break;
                }
                case 1: {
                    Type.TLong tLong = (Type.TLong)type3;
                    buf.method_52974(((Long)data).longValue());
                    break;
                }
                case 2: {
                    Type.TFloat tFloat = (Type.TFloat)type3;
                    buf.method_52941(((Float)data).floatValue());
                    break;
                }
                case 3: {
                    Type.TDouble tDouble = (Type.TDouble)type3;
                    buf.method_52940(((Double)data).doubleValue());
                    break;
                }
                case 4: {
                    Type.TString tString = (Type.TString)type3;
                    buf.method_10814((String)data);
                    break;
                }
                case 5: {
                    Type.TBool tBool = (Type.TBool)type3;
                    buf.method_52964(((Boolean)data).booleanValue());
                    break;
                }
                case 6: {
                    Type.TEnum tEnum = (Type.TEnum)type3;
                    buf.method_10814(data.toString());
                    break;
                }
                case 7: {
                    Type.TUnknown tUnknown = (Type.TUnknown)type3;
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public T getValue() {
        class_2540 buf = PacketByteBufs.create();
        this.writePath(buf);
        buf = this.sendRequest("getEntryValue", buf);
        return (T)MirrorEntryInfo.read(buf, this.valueType);
    }

    public void setValue(T value) {
        class_2540 buf = PacketByteBufs.create();
        this.writePath(buf);
        MirrorEntryInfo.write(buf, this.valueType, value);
        this.sendRequest("setEntryValue", buf);
    }
}

